import $ from 'jquery';

class AnchorNavigation {
    constructor() {
        this.container = $('#content');
        this.navigationBlock = this.container.find('.block-anchor-navigation');

        this.classes = [
            '.container',
        ];

        if (!this.container.length) {
            return;
        }
        this.generate();
    }

    /**
     * Append given content template to given element.
     * Normally the element is of type list and the content a list of links as html string.
     */

    appendContent(element, content) {
        if (!element.length) {
            return;
        }

        element.append(content);
    }

    /**
     * Show given element and append given content template.
     */

    showContent(element, contentElement, content) {
        if (!element.length || !contentElement.length) {
            return;
        }

        element.show();

        this.appendContent(contentElement, content);
    }

    /**
     * Get all elements of type link-anchor inside of given section.
     */

    getAnchors(section) {
        return section.find('.link-anchor');
    }

    /**
     * Get all stages with given classes until next stage of type anchor-navigation.
     */

    getSections(navigation, classes) {
        return navigation.nextUntil('.block-anchor-navigation', classes.join(', '));
    }

    /**
     * Get all stages of type anchor-navigation inside of given container.
     */

    getNavigations(container) {
        return container.find('.block-anchor-navigation');
    }

    /**
     * Generate the template html string from elements on the page.
     */

    generate() {
        this.getNavigations(this.container).each((index, navigation) => {
            navigation = $(navigation);

            let template = '';

            this.getSections(navigation, this.classes).each((index, section) => {
                section = $(section);

                this.getAnchors(section).each(function(index, anchor) {
                    anchor = $(anchor);
                    const text = anchor.text();
                    const link = anchor.attr('id');

                    template += '<li>';
                    template += '<a href="' + '#' + link + '" class="scroll-to">';
                    template += text;
                    template += '</a>';
                    template += '</li>';
                });
            });

            const blockId = '#' + navigation.attr('id');
            // Guess child element ids
            // const navigationId = blockId + '-content';
            const navigationListId = blockId + '-list';

            // Append content to the current navigation.
            this.showContent(navigation, navigation.find(navigationListId), template);
        });
    }
}

(function(document) {
    new AnchorNavigation();
})(document);
