import $ from 'jquery';

class Navbar {
    toggleAnimation() {
        const $navbarToggler = $('.navbar-toggler');

        $navbarToggler.on('click', function() {
            $navbarToggler.toggleClass('active');
            $('body').toggleClass('open'); // Fix body Scroll on mobile
        });

        // $(window).resize(function(){ $('.navbar-toggler').removeClass('active');});
    }

    openSearch() {
        const $openSearchBtn = $('#open-search');
        $openSearchBtn.on('click', function() {
            $('#search-overlay').addClass('active');
            $('body').toggleClass('open');
            setTimeout(function() {
                $('#search-overlay-input').focus();
            }, 500);
        });
    }

    closeSearch() {
        const $closeSearchBtn = $('#close-search');
        $closeSearchBtn.on('click', function() {
            $('#search-overlay').removeClass('active');
            $('body').removeClass('open');
        });

        $('#search-overlay').mouseup(function(e) {
            const container = $('.search-overlay-content');
            if (!container.is(e.target) && container.has(e.target).length === 0) {
                $('#search-overlay').removeClass('active');
                $('body').removeClass('open');
            }
        });
    }

    stickyNavbar() {
        const $header = $('.header_page');
        const $navbar = $('.lsnavbar-sticky');

        if ($navbar[0]) {
            const limit = $header.outerHeight();
            let position = $(window).scrollTop();

            $(window).on('scroll', /* @this HTMLElement */ function(event) {
                const scrolltop = $(this).scrollTop();

                if (scrolltop > limit + 100) {
                    $navbar.addClass('sticked');
                    $header.css('margin-bottom', limit); // Fix Body Padding on Sticky navbar
                    $navbar.addClass('in');
                }
                if (scrolltop < position) {
                    $navbar.removeClass('sticked').removeClass('in');
                    $header.css('margin-bottom', 0); // Fix Body Padding on Sticky navbar
                }
                position = scrolltop;
            });
        }
    }
}

(function(document) {
    const navbar = new Navbar();
    navbar.toggleAnimation();
    navbar.openSearch();
    navbar.closeSearch();
    navbar.stickyNavbar();
})(document);
