/**
 * Scroll to top element
 * */

import $ from 'jquery';

class ScrollToTop {
    constructor(eventTarget, amountScrolled) {
        this.eventTarget = eventTarget;
        this.amountScrolled = amountScrolled;

        if (this.eventTarget.length) {
            this.eventTarget.on('click', function() {
                $('html, body').animate({scrollTop: 0}, 'slow');
                return false;
            });
        }
    }

    showToTopButton() {
        if ($(window).scrollTop() > this.amountScrolled + 150) {
            this.eventTarget.fadeIn('slow');
        } else {
            this.eventTarget.fadeOut('slow');
        }
    }
}

const scrollToTop = new ScrollToTop($('#to-top-container'), 250);

$(window).scroll(function() {
    scrollToTop.showToTopButton();
});
