export default class Cookie {
    static setCookieExpire(days) {
        const date = new Date();
        if (days) {
            date.setTime(date.getTime()+(days*24*60*60*1000));
        } else {
            date.setTime(date.getTime()+(365*24*60*60*1000));
        }
        return date;
    }

    static setCookie(name, value, days) {
        const cookieExpires = Cookie.setCookieExpire(days);
        document.cookie = name + '=' + value + ';' + cookieExpires + ';path=/';
    }

    static deleteCookie(name) {
        document.cookie = name+'=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;';
    }

    static getCookie(name) {
        const nameEQ = name + '=';
        const ca = document.cookie.split(';');
        for (let i=0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0)===' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    }
}
