/**
 *  init hero images slider
 */

import $ from 'jquery';

class SliderHero {
    constructor() {
        const arrowRight = '<i class="arrow slick-next">\n' +
            '<svg width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
            '<polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" ' +
            'stroke-linejoin="round" points="\n' +
            '0.375,0.375 45.63,38.087 0.375,75.8 "/>\n' +
            '</svg>\n' +
            '</i>';
        const arrowLeft = '<i class="arrow slick-prev">\n' +
            '<svg width="40px" height="80px" viewBox="0 0 50 80" xml:space="preserve">\n' +
            '<polyline fill="none" stroke="#FFFFFF" stroke-width="1" stroke-linecap="round" ' +
            'stroke-linejoin="round" points="\n' +
            '45.63,75.8 0.375,38.087 45.63,0.375 "/>\n' +
            '</svg>\n' +
            '</i>';
        const slideWrapper = $('.js-slider-heroimage');

        slideWrapper.slick({
            // fade:true,
            autoplaySpeed: 4000,
            lazyLoad: 'progressive',
            speed: 600,
            arrows: true,
            touchMove: false,
            adaptiveHeight: false,
            dots: true,
            nextArrow: arrowRight,
            prevArrow: arrowLeft,
            cssEase: 'cubic-bezier(0.87, 0.03, 0.41, 0.9)',
        });
    }
}

(function(document) {
    new SliderHero();
})(document);
