/**
 * Get sylius status and change dom elements
 */

import $ from 'jquery';

class SyliusStatus {
    constructor() {
        this.statusUrl = '/' + config.locale + '/ajax/sylius/status-menu';
        this.$cartContainer = $('#navbar-cart');
        this.$userContainer = $('.navbar-user');
        this.updateStatus();
    }

    updateStatus() {
        $.getJSON(this.statusUrl).done((html) => {
            this.$cartContainer.empty();
            this.changeCartStatus(html.cart_status);
            this.changeUserStatus(html.user_status);
        });
    }

    changeCartStatus(cartHtml) {
        this.$cartContainer.empty();
        this.$cartContainer.append(cartHtml);
        this.$cartContainer.find('.badge').fadeIn();
    }

    changeUserStatus(userHtml) {
        this.$userContainer.empty();
        this.$userContainer.append(userHtml);
    }
}

(function(document) {
    new SyliusStatus();
})(document);
