/**
 * Change columns in grid view
 * */

import $ from 'jquery';
import Cookie from './cookies';

class Gridview {
    constructor() {
        const $productGrid = $('.product-grid');
        const $colswitchType = $('.colswitch__type');

        $colswitchType.on('click', (event) => {
            const $target = $(event.currentTarget);
            const dataCols = $target.attr('data-cols');

            Cookie.setCookie('grid', dataCols);
            $colswitchType.removeClass('active');
            $target.addClass('active');
            $productGrid.attr('data-grid', dataCols);
        });
    }
}

(function(document) {
    new Gridview();
})(document);
