import $ from 'jquery';

export class Hotspot {
    constructor(marker) {
        this.marker = marker;

        $('.hotspots__hotspot__overlay__close').on('click', function(event) {
            $('.popover').popover('hide');
        });

        $('#content').on('mouseup', function(event) {
            const $element = $(event.target);

            if ($element[0].className.indexOf('popover') == -1) {
                $('.popover').popover('hide');
            }
        });
    }

    handleMarker() {
        if (this.marker.length !== 0) {
            this.marker.popover({
                html: true,
                trigger: 'click',
                placement: 'bottom',
                content: function(e) {
                    const cloneContent = $($(this).data('popover-content')).
                        clone(true).
                        removeClass('d-none');
                    return cloneContent;
                },
            }).click(function(e) {
                e.preventDefault();
            });
        }
    }
}

(function(document) {
    new Hotspot($('.hotspots__map__marker')).handleMarker();
})(document);
