/**
 *  init swooxfilter functions
 *  and add custom scrollbars
 */

import $ from 'jquery';
import PerfectScrollbar from 'perfect-scrollbar';

class SwooxFilter {
    constructor() {
        this.$filterContainer = $('.searchresults__filter');
        this.$filterform = $('#filter-panel form, .filter-panel form');
        this.$resetFilterButton = $('.resetfilter');

        if (!this.$filterContainer.length) {
            return;
        }

        this.customScrollbars();

        this.$filterform.find('input[type="checkbox"], input[type="radio"]').on('change', () => {
            this.$filterform.submit();
        });

        this.$filterform.find('select').on('change', () => {
            this.$filterform.submit();
        });

        this.$resetFilterButton.on('click', () => {
            this.resetForm($(this.$filterform));
            this.$filterform.submit();
        });

        if (this.$filterform.find('input:radio:checked, input:checkbox:checked, option:selected[value!=""]').length) {
            this.$resetFilterButton.addClass('shown');
        }

        this.$filterform.find('input:text').each(() => {
            if ($(this).val() !== '') {
                this.$resetFilterButton.addClass('shown');
            }
        });
    }

    customScrollbars() {
        const divs = document.querySelectorAll('.scrollbars');
        let i;

        for (i = 0; i < divs.length; ++i) {
            new PerfectScrollbar(divs[i]);
        }
    }

    resetForm() {
        this.$filterform.find('input:text, input:password, input:file, select, textarea').val('');
        this.$filterform.find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
    }
}

(function(document) {
    new SwooxFilter;
})(document);
