/**
 * animate breadcrumb on mobile
 */

import $ from 'jquery';

export class Breadcrumb {
    constructor(selector) {
        const containerWidth = selector.width();
        let ulWidth = 0;

        // get width of each element
        selector.find('li').each(function() {
            ulWidth = ulWidth + $(this).width();
        });

        // animate breadcrum if it dosen't fit
        if (containerWidth <= ulWidth) {
            $('.block-breadcrumb__overlay').css('display', 'block');
            selector.stop().delay(2000).animate({scrollLeft: containerWidth}, '1000');
        }
    }
}

(function() {
    new Breadcrumb($('.block-breadcrumb__list'));
})();
