import CookieConsentApi from 'cookie-consent-api';

document.addEventListener('DOMContentLoaded', function() {
    // Init API
    const cookieConsent = new CookieConsentApi({
        services: ['performance', 'analytics', 'marketing'],
    });

    // Show banner if cookies are not all configured
    if (!cookieConsent.isAllConfigured()) {
        document.querySelector('.cookie-consent-banner').classList.add('show');
    }

    // Hide consent banner when cookies are all configured
    cookieConsent.on('allConfigured', function() {
        document.querySelector('.cookie-consent-banner').classList.remove('show');
    });

    // Action : accept all services
    document.querySelector('.cookie-consent-btn-accept-all').addEventListener('click', function() {
        cookieConsent.acceptAll();

        document.querySelectorAll('.cookie-consent-status').forEach(function(elem) {
            elem.checked = true;
        });
        location.reload();
    });

    // Action : safe settings
    document.querySelector('.cookie-consent-btn-save').addEventListener('click', function() {
        document.querySelectorAll('.cookie-consent-settings-panel [data-service]').forEach(function(elem) {
            const service = elem.getAttribute('data-service');
            const serviceStatus = elem.querySelector('.cookie-consent-status');
            if (serviceStatus.checked) {
                cookieConsent.accept(service);
            } else {
                cookieConsent.refuse(service);
            }
        });
        location.reload();
    });

    // Action : refuse all services
    document.querySelector('.cookie-consent-btn-refuse-all').addEventListener('click', function() {
        document.querySelectorAll('.cookie-consent-settings-panel [data-service]').forEach(function(elem) {
            const service = elem.getAttribute('data-service');
            const serviceStatus = elem.querySelector('.cookie-consent-status');

            cookieConsent.refuse(service);
            serviceStatus.checked = false;
        });
        location.reload();
    });

    // Settings panel
    document.querySelectorAll('.cookie-consent-settings-panel [data-service]').forEach(function(elem) {
        const service = elem.getAttribute('data-service');
        const serviceStatus = elem.querySelector('.cookie-consent-status');

        if (cookieConsent.isAccepted(service)) {
            serviceStatus.checked = true;
        }

        // Action : toggle service
        serviceStatus.addEventListener('change', function(element) {
            if (element.checked) {
                cookieConsent.accept(service);
            } else {
                cookieConsent.refuse(service);
            }
        });
    });
});
