/**
 * get all links with a class scroll-to
 * bind a click function on it
 */

import $ from 'jquery';

class ScrollTo {
    constructor() {
        this.page = $('html, body');
        this.headerHeight = 0;
        this.outerHeight = $('.header_page').outerHeight();

        this.defaults = {
            offset: this.headerHeight,
            duration: 300,
            easing: 'swing',
            hold: (function() {
            }),
            complete: (function() {
            }),
        };

        this.registerEvents();
        this.getWindowLocation.bind(this);
    }

    /**
     * Get location
     */

    getWindowLocation(attributeName) {
        const location = window.location;

        if (typeof (attributeName) === 'string' && typeof (location[attributeName]) !== 'undefined') {
            return location[attributeName];
        } else {
            return location;
        }
    }

    isSamePath(pathOne, pathTwo) {
        pathOne = pathOne.replace(/^\//, '');
        pathTwo = pathTwo.replace(/^\//, '');

        return pathOne === pathTwo;
    }

    isSameHost(hostOne, hostTwo) {
        return hostOne === hostTwo;
    }

    /**
     * Execute the scrolling animation to an element.
     * Consider navigation height when scrolling.
     */

    scrollTo(element, offset, duration, easing, hold, complete) {
        if (!element.length) {
            return;
        }

        if (this.outerHeight) {
            this.defaults.offset = this.outerHeight;
        }

        // Use argument or defaults.
        offset = (typeof (offset) !== 'undefined') ? offset : this.defaults.offset;
        duration = (typeof (duration) !== 'undefined') ? duration : this.defaults.duration;
        easing = (typeof (easing) !== 'undefined') ? easing : this.defaults.easing;
        hold = (typeof (hold) !== 'undefined') ? hold : this.defaults.hold;
        complete = (typeof (complete) !== 'undefined') ? complete : this.defaults.complete;

        this.page.on('scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove', (event) => {
            this.page.stop();

            hold(event);
        });

        this.page.animate({
            scrollTop: element.offset().top - offset,
        }, duration, easing, () => {
            this.page.off('scroll mousedown wheel DOMMouseScroll mousewheel keyup touchmove');

            complete();
        });
    }

    /**
     * Register all events needed for this module.
     */

    registerEvents() {
        // TODO: Make dynamic. But make sure dynamic update to the page are recognized.
        $('a.scroll-to').click((event) => {
            const element = $(this);
            event.preventDefault();

            if (element.attr('href') === '#') {
                // Special case: Do nothing if link href is equal to "#" only
                return;
            }

            if (this.isSamePath(this.getWindowLocation('pathname'), event.currentTarget.pathname) &&
                this.isSameHost(this.getWindowLocation('hostname'), event.currentTarget.hostname)) {
                let targetHash = event.currentTarget.hash;
                // The hash part is also the id selector
                let targetElement = $(targetHash);

                if (!targetElement.length) {
                    targetHash = targetHash.substring(1);

                    // If not found by id selector, try the name
                    targetElement = $('[name="' + targetHash + '"]');
                }

                this.scrollTo(targetElement);
            }
        });
    }
}

(function(document) {
    new ScrollTo();
    const $formMessage = $('.forms__message');

    if ($formMessage.length) {
        $([document.documentElement, document.body]).animate({
            scrollTop: $formMessage.offset().top - 140,
        }, 400);
    }
})(document);
