# Life-Style Swoox Massive Search Bundle

## Add Result Item Mappers

To map the search response items to your project specific object structures, create mappers.
Each mapper has to be a Symfony service tagged with ```lifestyle.swoox.item.mapper```

The bundle also provides some nice [helpers](item-value-mapper.md) for your mapper.

```php
<?php

namespace AppBundle\View\Mapper\Product;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxItemInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxItemMapperInterface;
use Swoox\Api\Model\Response\Search\Standard\Item;

class MyItemMapper implements SwooxItemMapperInterface
{
    /**
     * @param Item $item
     * @param string $locale
     * @return bool
     */
    public function isResponsible(Item $item, string $locale): bool
    {
        // Check responsibility and return true or false
        return $this->can_I_handle_this_item($item) && $this->can_I_handle_this_locale($locale);
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return SwooxItemInterface
     */
    public function map(Item $item, string $locale): SwooxItemInterface
    {
        // Map Swoox item response values to your project specific model
        // which must implement SwooxItemInterface
        $responseItem = $this->my_model_factory->create_my_model();
        $responseItem->set_my_value($this->map_my_value($item, $locale));
        ...

        return $responseItem;
    }
}
``` 

```yaml
services:
    AppBundle\View\Mapper\Product\MyItemMapper:
        public: false
        tags:
            - { name: lifestyle.swoox.item.mapper }
```

If you want to keep it simple, use the [item value mapper](item-value-mapper.md) inside your
result item mapper.
