<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager;

/**
 * Class Configuration
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @var string
     */
    private $clientId;

    /**
     * @var string
     */
    private $apiDomain;

    /**
     * @var int
     */
    private $localeSlotId;

    /**
     * @var int
     */
    private $defaultLimit;

    /**
     * Configuration constructor.
     * @param string $clientId
     * @param string $apiDomain
     * @param int $localeSlotId
     * @param int $defaultLimit
     */
    public function __construct(string $clientId, string $apiDomain, int $localeSlotId, int $defaultLimit)
    {
        $this->clientId = $clientId;
        $this->apiDomain = $apiDomain;
        $this->localeSlotId = $localeSlotId;
        $this->defaultLimit = $defaultLimit;
    }

    /**
     * @return string
     */
    public function getClientId(): string
    {
        return $this->clientId;
    }

    /**
     * @return string
     */
    public function getApiDomain(): string
    {
        return $this->apiDomain;
    }

    /**
     * @return int
     */
    public function getLocaleSlotId(): int
    {
        return $this->localeSlotId;
    }

    /**
     * @return int
     */
    public function getDefaultLimit(): int
    {
        return $this->defaultLimit;
    }
}
