<?php
/**
 * Created by PhpStorm.
 * User: minduser
 * Date: 05.10.18
 * Time: 11:49
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model\Factory;
use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class DefaultItemMapper
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper
 */
class DefaultItemMapper implements SwooxItemMapperInterface
{
    /**
     * @var Factory
     */
    private $modelFactory;

    /**
     * DefaultItemMapper constructor.
     * @param Factory $modelFactory
     */
    public function __construct(Factory $modelFactory)
    {
        $this->modelFactory = $modelFactory;
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return bool
     */
    public function isResponsible(Item $item, string $locale): bool
    {
        return true;
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return SwooxItemInterface
     */
    public function map(Item $item, string $locale): SwooxItemInterface
    {
        return $this->modelFactory->defaultItem()->map($item, $locale);
    }
}
