<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\Database;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\Entity\CmsExport;

/**
 * Class Manager
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\Database
 */
class Manager
{
    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    /**
     * @var EntityManager
     */
    private $em;

    /**
     * Manager constructor.
     * @param DoctrineRegistry $doctrineRegistry
     */
    public function __construct(DoctrineRegistry $doctrineRegistry)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->em = $this->doctrineRegistry->getManager();
    }

    /**
     * @return CmsExport
     */
    public function cmsExportEntity()
    {
        return new CmsExport();
    }

    /**
     * @param CmsExport $cmsExport
     */
    public function saveOrUpdate(CmsExport $cmsExport)
    {
        $repos = $this->doctrineRegistry->getRepository('LifeStyleSuluSwooxMassiveSearchBundle:CmsExport');
        $cmsExportEntity = $repos->findOneBy(['url' => $cmsExport->getUrl(),'locale' => $cmsExport->getLocale()]);

        if (null !== $cmsExportEntity) {
            $cmsExportEntity->setUpdated($cmsExport->getUpdated());
            $cmsExportEntity->setActive($cmsExport->isActive());
            $cmsExportEntity->setUrl($cmsExport->getUrl());
            $cmsExportEntity->setLocale($cmsExport->getLocale());

            $this->em->persist($cmsExportEntity);
            $this->em->flush($cmsExportEntity);
        } else {
            $this->em->persist($cmsExport);
            $this->em->flush($cmsExport);
        }
    }

    /**
     * @return CmsExport[]|null
     */
    public function findAllCmsEntities()
    {
        $repos = $this->doctrineRegistry->getRepository('LifeStyleSuluSwooxMassiveSearchBundle:CmsExport');
        return $repos->findAll();
    }
}
