<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Pagination\LsPaginationInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Model\Response\StandardResponse;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model\Factory;
use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class SwooxMapperChain
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper
 */
class SwooxMapperChain implements SwooxMapperChainInterface
{
    /**
     * @var Factory
     */
    private $modelFactory;

    /**
     * @var SwooxItemMapperInterface[]
     */
    private $mapper = [];

    /**
     * SwooxMapperChain constructor.
     * @param Factory $modelFactory
     */
    public function __construct(Factory $modelFactory)
    {
        $this->modelFactory = $modelFactory;
    }

    /**
     * @param SwooxItemMapperInterface $mapper
     */
    public function addMapper(SwooxItemMapperInterface $mapper)
    {
        $this->mapper[] = $mapper;
    }

    /**
     * @param StandardResponse $standardResponse
     * @param string $locale
     * @return LsPaginationInterface
     */
    public function map(StandardResponse $standardResponse, string $locale): LsPaginationInterface
    {
        $pagination = $this->modelFactory->swooxPagination();
        $pagination->setCount($standardResponse->getCount());

        foreach ($standardResponse->getItems() as $item) {
            $pagination->addItem($this->mapItem($item, $locale));
        }

        return $pagination;
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return SwooxItemInterface|Item
     */
    private function mapItem(Item $item, string $locale): SwooxItemInterface
    {
        foreach ($this->mapper as $mapper) {
            if ($mapper->isResponsible($item, $locale)) {
                return $mapper->map($item, $locale);
            }
        }

        return $item;
    }
}
