<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class ProductValueMapper
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper
 */
class SwooxResponseMapper implements ValueMapperInterface
{
    /**
     * @var Item $item
     */
    private $item;

    /**
     * @var array
     */
    private $index;

    /**
     * ProductValueMapper constructor.
     * @param Item $item
     */
    public function __construct(Item $item)
    {
        $this->item = $item;
        $this->index = $this->buildIndex($item);
    }

    /**
     * @param Item $item
     * @return array
     */
    private function buildIndex(Item $item): array
    {
        $idx = [];
        foreach ($item->getDocumentFields() as $field) {
            if (!empty($field->getValues())) {
                $values = [];
                foreach ($field->getValues() as $value) {
                    $values[] = $value->getValue();
                }
                $idx[$field->getName()] = $values;
            } else {
                $idx[$field->getName()] = $field->getValue();
            }
        }
        return $idx;
    }

    /**
     * @param string $name
     * @return int
     */
    public function getValueAsInteger(string $name): int
    {
        return isset($this->index[$name]) ? (int)$this->index[$name] : 0;
    }

    /**
     * @param string $name
     * @return string
     */
    public function getValueAsString(string $name): string
    {
        return isset($this->index[$name]) ? (string)$this->index[$name] : '';
    }

    /**
     * @param string $name
     * @return bool
     */
    public function getValueAsBool(string $name): bool
    {
        return isset($this->index[$name]) ? (bool)$this->index[$name] : false;
    }

    /**
     * @param string $name
     * @return array
     */
    public function getValueAsArray(string $name): array
    {
        return isset($this->index[$name]) ? (array)$this->index[$name] : [];
    }
}
