<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\PriorityTaggedServiceTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\Reference;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxMapperChain;

/**
 * Class ProductMapperPass
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\DependencyInjection\Compiler
 */
class SwooxMapperChainPass implements CompilerPassInterface
{
    use PriorityTaggedServiceTrait;

    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->has(SwooxMapperChain::class)) {
            return;
        }

        $definition = $container->findDefinition(SwooxMapperChain::class);
        $container->findTaggedServiceIds('lifestyle.swoox.item.mapper');
        $taggedServices = $this->findAndSortTaggedServices('lifestyle.swoox.item.mapper', $container);

        foreach ($taggedServices as $reference) {
            $definition->addMethodCall('addMapper', array($reference));
        }
    }
}
