<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\Event;

use Symfony\Component\EventDispatcher\Event;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class PreUnpublishEvent
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\Event
 */
class PreUnpublishEvent extends Event
{
    const NAME = 'rabbit.mq.swoox.cms.unpublish';

    /**
     * @var DataCollectorInterface
     */
    protected $collector;

    /**
     * PreUnpublishEvent constructor.
     * @param DataCollectorInterface $collector
     */
    public function __construct(DataCollectorInterface $collector)
    {
        $this->collector = $collector;
    }

    /**
     * @return DataCollectorInterface
     */
    public function getCollector()
    {
        return $this->collector;
    }
}
