<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

/**
 * Interface ValueMapperFactoryInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\View\Mapper\Product
 */
interface ValueMapperFactoryInterface
{
    /**
     * @param object $object
     * @param string $className
     * @return bool
     */
    public function isResponsible($object, string $className): bool;

    /**
     * @param object $object
     * @param string $locale
     * @return ValueMapperInterface
     */
    public function createMapper($object, string $locale): ValueMapperInterface;
}
