<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

/**
 * Interface ProductValueMapperInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\View\Mapper\Product
 */
interface ValueMapperInterface
{
    /**
     * @param string $name
     * @return int
     */
    public function getValueAsInteger(string $name): int;

    /**
     * @param string $name
     * @return string
     */
    public function getValueAsString(string $name): string;

    /**
     * @param string $name
     * @return bool
     */
    public function getValueAsBool(string $name): bool;

    /**
     * @param string $name
     * @return array
     */
    public function getValueAsArray(string $name): array;
}
