# Life-Style Swoox Massive Search Bundle

## Configuration

As this bundle overwrites the massive search bundle, you must configure the
massive search bundle first. Feel free to replace the values below with variables,
to use them as parameters or environment variables in your environment.

Be sure to have a proper running instance of Swoox! 

_**File:** app/config/config.yml_ 
```yaml
massive_search:
    adapters:
        zend_lucene:
            basepath: "%kernel.var_dir%/indexes"
    persistence:
        doctrine_orm:
            enabled: true

life_style_sulu_swoox_massive_search:
    swoox_api_url: 'http://swoox-api.life-style.de'
    swoox_client_id: '4711'
    swoox_slot_locale: 4
    responsible:
      - 'page_website-name'
      - 'page_website-name_published'
```

## Configure Index Fields And Search Result

To tell the search bundle which fields of your pages should be indexed, configure
them in your projects page configuration:

_**File:** app/Resources/templates/pages/default.xml_
```xml
<?xml version="1.0" ?>
<template>
    <view>templates/default</view>
    ...
    <properties>
        <block>
            ...
            <types>
                <type name="textblock">
                    ...
                    <!-- add properties to search index -->
                    <properties>
                        <property name="article_headline" type="text_editor">
                            ...
                            <tag name="sulu.search.field" role="title" />
                        </property>
            
                        <property name="article_content" type="text_editor">
                            ...
                            <tag name="sulu.search.field" role="description" type="swoox" />
                        </property>
                    </properties>
                </type>
                ...
                <!-- define swoox search result description -->
                <type name="swoox_description">
                    <meta>
                        <title lang="en">Search Result - Description</title>
                        <title lang="de">Suchergebnis - Beschreibung</title>
                    </meta>
                    <properties>
                        <property name="swoox_description_box" type="text_editor" colspan="12">
                            <meta>
                                <title lang="en">Description</title>
                                <title lang="de">Beschreibung</title>
                            </meta>
                            <params>
                                <param name="table" value="false"/>
                                <param name="link" value="false"/>
                            </params>
                            <tag name="sulu.search.field" role="description" type="swoox" />
                        </property>
                    </properties>
                </type>
            </types>
         </block>
     </properties>
    ...
</template>
```

Now you should be able to start creating your own [result mappers](item-mapper.md).
