# Life-Style Swoox Massive Search Bundle

## Item Value Mapper

As each value inside a swoox response has nearly the same structure, this helper might be very useful for 
finding an casting values. The bundle provides a item-value-mapper-factory to create a item value mapper. 
Inject this factory service into your mapper.

The item value mapper currently is very user friendly. If a value is not found in the response, each method 
will return an empty value that fits to the return value type. If a exist-check has to be done, you have to 
do this in advance. 

It might look something like this:

```php
<?php

namespace AppBundle\View\Mapper\Product;

use AppBundle\View\Model\Factory;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\ValueMapperFactoryInterface;

class MyItemMapper implements SwooxItemMapperInterface
{
    /**
     * @var  Factory
     */
    private $productFactory;

    /**
     * @var ValueMapperFactoryInterface
     */
    private $valueMapperFactory;

    public function __construct(Factory $productFactory, ValueMapperFactoryInterface $valueMapperFactory)
    {
        $this->productFactory = $productFactory;
        $this->valueMapperFactory = $valueMapperFactory;
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return bool
     */
    public function isResponsible(Item $item, string $locale): bool
    {
        // Check responsibility and return true or false
        return $this->can_I_handle_this_item($item) && $this->can_I_handle_this_locale($locale);
    }

    /**
     * @param Item $item
     * @param string $locale
     * @return SwooxItemInterface
     */
    public function map(Item $item, string $locale): SwooxItemInterface
    {
        $valueMapper = $this->valueMapperFactory->createMapper($item, $locale);

        $product = $this->productFactory->product();
        $product->setString($valueMapper->getValueAsString('name_of_string_value_in_swoox_response'));
        $product->setBoolean($valueMapper->getValueAsBool('name_of_bool_value_in_swoox_response'));
        $product->setInteger($valueMapper->getValueAsInteger('name_of_integer_value_in_swoox_response'));
        $product->setArray($valueMapper->getValueAsArray('name_of_multi_value_in_swoox_response'));

        return $product;
    }
}

```

```yaml
services:
    AppBundle\View\Mapper\Product\MyItemMapper:
        public: false
        arguments:
            - "@AppBundle\View\Model\Factory"
            - "@LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\ValueMapperFactoryInterface"
        tags:
            - { name: lifestyle.swoox.item.mapper }
```
