<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form;

use Symfony\Component\Form\FormInterface;
use Swoox\Api\Model\Response\Search\Filter\FilterResponse;

/**
 * Interface SwooxFilterFormBuilderInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form
 */
interface SwooxFilterFormBuilderInterface
{
    /**
     * Map Swoox filter response to Symfony form
     *
     * This can be used in controllers to build a proper form for search filters
     *
     * @param FilterResponse $filterResponse
     * @return FormInterface
     */
    public function buildFilterForm(FilterResponse $filterResponse): FormInterface;
}
