<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Pagination\LsPaginationInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Model\Response\StandardResponse;

/**
 * Interface SwooxMapperChainInterface
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper
 */
interface SwooxMapperChainInterface
{
    /**
     * @param StandardResponse $standardResponse
     * @param string $locale
     * @return LsPaginationInterface
     */
    public function map(StandardResponse $standardResponse, string $locale): LsPaginationInterface;
}
