<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxItemInterface;
use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class DefaultItem
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model
 */
class DefaultItem extends Item implements SwooxItemInterface
{
    /**
     * @return $this
     */
    public function map(Item $item, string $locale)
    {
        $this->documentFields = $item->getDocumentFields();
        $this->template = $item->getTemplate();
        return $this;
    }

    /**
     * @return string
     */
    public function getItemName()
    {
        return 'DefaultItem';
    }
}
