<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\Converter;

use Massive\Bundle\SearchBundle\Search\Converter\ConverterInterface;

/**
 * Class SwooxConverter
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\Converter
 */
class SwooxConverter implements ConverterInterface
{
    const SWOOX_IDENTIFIER = '##swoox##';

    /**
     * @param mixed $value
     * @return mixed
     */
    public function convert($value)
    {
        return self::SWOOX_IDENTIFIER . (string)$value;
    }
}
