<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Interface SwooxItemMapperInterface
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper
 */
interface SwooxItemMapperInterface
{
    /**
     * @param Item $item
     * @param string $locale
     * @return bool
     */
    public function isResponsible(Item $item, string $locale): bool;

    /**
     * @param Item $item
     * @param string $locale
     * @return SwooxItemInterface
     */
    public function map(Item $item, string $locale): SwooxItemInterface;
}
