<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxItemInterface;
use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class DefaultItem
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model
 */
class DefaultCmsItem implements SwooxItemInterface
{

    const NAME_TITLE = 'TITLE';
    const NAME_URL = 'URL';
    const SEARCH_RESULT_DESCRIPTION = 'SEARCH_RESULT_DESCRIPTION';

    /**
     * @var int
     */
    private $rankPosition;

    /**
     * @var int
     */
    private $hitPosition;

    /**
     * @var string
     */
    private $score;

    /**
     * @var string
     */
    private $template = '';

    /**
     * @var string
     */
    private $title = '';

    /**
     * @var string
     */
    private $searchResultDescription = '';

    /**
     * @var string
     */
    private $url = '';

    /**
     * @var string
     */
    private $locale = '';

    /**
     * @param Item $item
     * @param string $locale
     * @return $this
     */
    public function map(Item $item, string $locale)
    {
        $this->setLocale($locale);
        $this->setTemplate($item->getTemplate() ? $item->getTemplate() : '');
        $this->setHitPosition($item->getHitPosition() ? (int)$item->getHitPosition() : 0);
        $this->setRankPosition($item->getRankPosition() ? (int)$item->getRankPosition() : 0);
        $this->setScore($item->getScore() ? $item->getScore() : '');

        foreach ($item->getDocumentFields() as $documentField) {

            if (self::NAME_TITLE === $documentField->getName()) {
                $this->setTitle($documentField->getValue() ? $documentField->getValue() : '');
            }

            if (self::NAME_URL === $documentField->getName()) {
                $this->setUrl($documentField->getValue() ? $documentField->getValue() : '');
            }

            if (self::SEARCH_RESULT_DESCRIPTION === $documentField->getName()) {
                $this->setSearchResultDescription($documentField->getValue() ? $documentField->getValue() : '');
            }
        }

        return $this;
    }

    /**
     * @return int
     */
    public function getRankPosition(): int
    {
        return $this->rankPosition;
    }

    /**
     * @param int $rankPosition
     * @return DefaultCmsItem
     */
    public function setRankPosition(int $rankPosition): DefaultCmsItem
    {
        $this->rankPosition = $rankPosition;
        return $this;
    }

    /**
     * @return int
     */
    public function getHitPosition(): int
    {
        return $this->hitPosition;
    }

    /**
     * @param int $hitPosition
     * @return DefaultCmsItem
     */
    public function setHitPosition(int $hitPosition): DefaultCmsItem
    {
        $this->hitPosition = $hitPosition;
        return $this;
    }

    /**
     * @return string
     */
    public function getScore(): string
    {
        return $this->score;
    }

    /**
     * @param string $score
     * @return DefaultCmsItem
     */
    public function setScore(string $score): DefaultCmsItem
    {
        $this->score = $score;
        return $this;
    }

    /**
     * @return string
     */
    public function getItemName()
    {
        return 'DefaultCmsItem';
    }

    /**
     * @return string
     */
    public function getTemplate(): string
    {
        return $this->template;
    }

    /**
     * @param string $template
     * @return DefaultCmsItem
     */
    public function setTemplate(string $template): DefaultCmsItem
    {
        $this->template = $template;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return DefaultCmsItem
     */
    public function setTitle(string $title): DefaultCmsItem
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getSearchResultDescription(): string
    {
        return $this->searchResultDescription;
    }

    /**
     * @param string $searchResultDescription
     * @return DefaultCmsItem
     */
    public function setSearchResultDescription(string $searchResultDescription): DefaultCmsItem
    {
        $this->searchResultDescription = $searchResultDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getUrl(): string
    {
        return $this->url;
    }

    /**
     * @param string $url
     * @return DefaultCmsItem
     */
    public function setUrl(string $url): DefaultCmsItem
    {
        $this->url = $url;
        return $this;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     * @return DefaultCmsItem
     */
    public function setLocale(string $locale): DefaultCmsItem
    {
        $this->locale = $locale;
        return $this;
    }
}
