<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\DependencyInjection;

use PHPCR\ConfigurationException;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class LifeStyleSuluSwooxMassiveSearchExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.xml');
        $this->configureAdapter(
            $config['responsible'],
            $container
        );

        $this->configureSwoox(
            $config,
            $container
        );

    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     * @throws ConfigurationException
     */
    private function configureAdapter(array $config, ContainerBuilder $container)
    {
        $serviceId = 'massive_search.adapter.zend_lucene';
        $this->validateService($serviceId, $container);

        $service = $container->getDefinition($serviceId);
        $service->setArgument(5, $config);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     * @throws ConfigurationException
     */
    private function configureSwoox(array $config, ContainerBuilder $container)
    {
        $serviceId = 'LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Configuration';
        $this->validateService($serviceId, $container);

        $defintion = $container->getDefinition($serviceId);
        $defintion->setArguments([
            $config['swoox_client_id'],
            $config['swoox_api_url'],
            $config['swoox_slot_locale'],
            $config['swoox_request_default_limit'],
            $config['swoox_filter_select_sorting'],
        ]);
    }

    /**
     * @param string $serviceId
     * @param ContainerBuilder $container
     * @throws ConfigurationException
     */
    private function validateService($serviceId, ContainerBuilder $container)
    {
        if (!$container->hasDefinition($serviceId)) {
            throw new ConfigurationException(sprintf(
                'Missing service "%s" for configuration!',
                $serviceId
            ));
        }
    }
}
