<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\EventListener;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Pagination\LsPaginationInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Knp\Component\Pager\Event\ItemsEvent;

/**
 * Class PaginationSubscriber
 * @package LifeStyle\Tools\RestPaginationBundle\Subscriber
 */
class PaginationSubscriber implements EventSubscriberInterface
{
    /**
     * @param ItemsEvent $event
     */
    public function items(ItemsEvent $event)
    {
        if ($event->target instanceof LsPaginationInterface) {
            $event->count = $event->target->getCount();
            if(null !== $event->target->getSortableList() || is_array($event->target->getSortableList())){
                $event->items = $event->target->getSortableList();
            } else {
                $event->items = [];
            }
            $event->stopPropagation();
        }
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return array(
            'knp_pager.items' => array('items', 1/*increased priority to override any internal*/),
        );
    }
}
