<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\EventListener;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Database\Manager as DbManager;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\Event\PrePublishEvent;

/**
 * Class PrePublishListener
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\EventListener
 */
class PrePublishListener
{
    /**
     * @var DbManager
     */
    private $dbManager;

    /**
     * PrePublishListener constructor.
     * @param DbManager $dbManager
     */
    public function __construct(DbManager $dbManager)
    {
        $this->dbManager = $dbManager;
    }

    /**
     * @param PrePublishEvent $prePublishEvent
     */
    public function prePublish(PrePublishEvent $prePublishEvent)
    {
        $collector = $prePublishEvent->getCollector();
        if($collector->hasItem('id')){
            $cmsEntity = $this->dbManager->cmsExportEntity();
            $cmsEntity->setCmsId($collector->getItemValue('id'));
            $cmsEntity->setActive(true);
            $cmsEntity->setUrl($collector->hasItem('URL') ? $collector->getItemValue('URL') : '');
            $cmsEntity->setLocale($collector->hasItem('LOCALE') ? $collector->getItemValue('LOCALE') : '');
            $cmsEntity->setUpdated(new \DateTime());
            $cmsEntity->setCreated(new \DateTime());

            $this->dbManager->saveOrUpdate($cmsEntity);
        }
    }
}
