<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Model\Response\StandardResponse;
use Swoox\Api\Model\Response\Search\Filter\FilterResponse;

/**
 * Interface SearchHandlerInterface
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager
 */
interface SearchHandlerInterface
{
    /**
     * @param array $searchParams
     * @param string $locale
     * @return null|StandardResponse
     */
    public function standardSearch(array $searchParams, $locale);

    /**
     * @param array $searchParams
     * @param string $locale
     * @return null|FilterResponse
     */
    public function filterSearch(array $searchParams, $locale);
}
