<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper;

use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class SwooxResponseMapperFactory
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\View\Mapper\Product
 */
class SwooxResponseMapperFactory implements ValueMapperFactoryInterface
{
    /**
     * @param object $object
     * @param string $className
     * @return bool
     */
    public function isResponsible($object, string $className): bool
    {
        if (!($object instanceof Item)) {
            return false;
        }

        foreach ($object->getDocumentFields() as $field) {
            if ('className' === $field->getName() && $field->getValue() === $className) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param object $object
     * @param string $locale
     * @return ValueMapperInterface
     */
    public function createMapper($object, string $locale): ValueMapperInterface
    {
        return new SwooxResponseMapper($object);
    }
}
