<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\EventListener;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Adapter\Export\SwooxExportAdapter;
use Massive\Bundle\SearchBundle\Search\Decorator\IndexNameDecoratorInterface;
use Massive\Bundle\SearchBundle\Search\Event\IndexRebuildEvent;

/**
 * Class SwooxRebuildSubscriber
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\EventListener
 */
class SwooxRebuildSubscriber
{
    /**
     * @var SwooxExportAdapter
     */
    private $adapter;

    /**
     * @var IndexNameDecoratorInterface
     */
    private $indexNameDecorator;

    /**
     * SwooxRebuildSubscriber constructor.
     * @param SwooxExportAdapter $adapter
     * @param IndexNameDecoratorInterface $indexNameDecorator
     */
    public function __construct(SwooxExportAdapter $adapter, IndexNameDecoratorInterface $indexNameDecorator)
    {
        $this->adapter = $adapter;
        $this->indexNameDecorator = $indexNameDecorator;
    }

    /**
     * Optimize the search indexes after the index rebuild event has been fired.
     * Should have a priority low enough in order for it to be executed after all
     * the actual index builders.
     *
     * @param IndexRebuildEvent $event
     */
    public function onIndexRebuild(IndexRebuildEvent $event)
    {
        foreach ($this->adapter->listIndexes() as $indexName) {
            if (!$this->indexNameDecorator->isVariant($this->indexNameDecorator->undecorate($indexName), $indexName)) {
                continue;
            }

            $event->getOutput()->writeln(sprintf('<info>Optimizing zend lucene index:</info> %s', $indexName));
            $this->adapter->optimize($indexName);
        }
    }
}
