<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form\SwooxFilterFormBuilderInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\SearchHandlerInterface;
use Symfony\Component\Form\FormInterface;

/**
 * Class FilterEngine
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View
 */
class FilterEngine implements FilterEngineInterface
{
    /**
     * @var SearchHandlerInterface
     */
    private $searchHandler;

    /**
     * @var SwooxFilterFormBuilderInterface
     */
    private $swooxFilterFormBuilder;

    /**
     * FilterEngine constructor.
     * @param SearchHandlerInterface $searchHandler
     * @param SwooxFilterFormBuilderInterface $swooxFilterFormBuilder
     */
    public function __construct(
        SearchHandlerInterface $searchHandler,
        SwooxFilterFormBuilderInterface $swooxFilterFormBuilder
    ) {
        $this->searchHandler = $searchHandler;
        $this->swooxFilterFormBuilder = $swooxFilterFormBuilder;
    }

    /**
     * @param array $searchParams
     * @param string $locale
     * @return FormInterface
     */
    public function buildFilterForm(array $searchParams, string $locale): FormInterface
    {
        $searchParams = $this->parseSearchParams($searchParams);
        $filterSearchResponse = $this->searchHandler->filterSearch($searchParams, $locale);

        if (null === $filterSearchResponse) {
            throw new \Exception('TODO: What if swoox filter search failed?');
        }

        return $this->swooxFilterFormBuilder->buildFilterForm($filterSearchResponse);
    }

    /**
     * @param array $searchParams
     * @return array
     */
    private function parseSearchParams(array $searchParams): array
    {
        unset(
            $searchParams['page'],
            $searchParams['q'],
            $searchParams['filter'],
            $searchParams['_token']
        );

        return $searchParams;
    }
}
