# Life-Style Swoox Massive Search Bundle

## Use Swoox Search In Your Project

**This bundle is connected to the Sulu standard search. In most cases this will
fulfill your requirements.** If you want to send customized search requests,
this bundle provides some public services:

- [LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form\SwooxFilterFormBuilderInterface](../src/SearchManager/Form/SwooxFilterFormBuilderInterface.php)
- [LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\ConfigurationInterface](../src/SearchManager/ConfigurationInterface.php)
- [LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\SearchHandlerInterface](../src/SearchManager/SearchHandlerInterface.php)
- [LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxMapperChainInterface](../src/View/Mapper/SwooxMapperChainInterface.php)

Use dependency injection in your class (or set autowire and autoconfigure to true):

```yaml
services:
    App\AdvancedSearch:
        arguments:
            - "@LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\SearchHandlerInterface"
            - "@LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxMapperChainInterface"
            - "@LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form\SwooxFilterFormBuilderInterface"
            - "@LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\ConfigurationInterface"
```

In your class:
```php
<?php

namespace App;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\ConfigurationInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\Form\SwooxFilterFormBuilderInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\SearchManager\SearchHandlerInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxMapperChainInterface;

/**
 * Class WebsiteSearchController
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\Controller
 */
class AdvancedSearch
{
    /**
     * @var SearchHandlerInterface
     */
    private $searchHandler;

    /**
     * @var SwooxMapperChainInterface
     */
    private $swooxMapperChain;

    /**
     * @var SwooxFilterFormBuilderInterface
     */
    private $swooxFilterFormBuilder;

    /**
     * @var ConfigurationInterface
     */
    private $swooxConfiguration;

    /**
     * AdvancedSearch constructor.
     * @param SearchHandlerInterface $searchHandler
     * @param SwooxMapperChainInterface $swooxMapperChain
     * @param SwooxFilterFormBuilderInterface $swooxFilterFormBuilder
     * @param ConfigurationInterface $swooxConfiguration
     */
    public function __construct(
        SearchHandlerInterface $searchHandler,
        SwooxMapperChainInterface $swooxMapperChain,
        SwooxFilterFormBuilderInterface $swooxFilterFormBuilder,
        ConfigurationInterface $swooxConfiguration
    ) {
        $this->searchHandler = $searchHandler;
        $this->swooxMapperChain = $swooxMapperChain;
        $this->swooxFilterFormBuilder = $swooxFilterFormBuilder;
        $this->swooxConfiguration = $swooxConfiguration;
    }

    /**
     * @param array $searchParams
     * @param string $locale
     */
    public function search(array $searchParams, string $locale)
    {
        if (!isset($searchParams['limit'])) {
            $searchParams['limit'] = $this->swooxConfiguration->getDefaultLimit();
        }

        $searchResponse = $this->searchHandler->standardSearch($searchParams, $locale);
        $searchResponseModel = $this->swooxMapperChain->map($searchResponse, $locale);

        $filterResponse = $this->searchHandler->filterSearch($searchParams, $locale);
        $form = $this->swooxFilterFormBuilder->buildFilterForm($filterResponse);

        // Do something with $searchResponseModel and $form
        
    }
}
```
