<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\Adapter\RabbitMq;

use OldSound\RabbitMqBundle\RabbitMq\ProducerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class Producer
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\Adapter\RabbitMq
 */
class Producer implements ProducerInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var string
     */
    private $producerName;

    /**
     * Producer constructor.
     * @param ContainerInterface $container
     * @param string $producerName
     */
    public function __construct(ContainerInterface $container, string $producerName)
    {
        $this->container = $container;
        $this->producerName = $producerName;
    }

    /**
     * Publish a message
     *
     * @param string $msgBody
     * @param string $routingKey
     * @param array $additionalProperties
     */
    public function publish($msgBody, $routingKey = '', $additionalProperties = array())
    {
        // This is not very nice, but it reduces the number ob connections to rabbitMq
        $this
            ->container
            ->get('old_sound_rabbit_mq.' . $this->producerName . '_producer')
            ->publish($msgBody, $routingKey, $additionalProperties);
    }
}
