<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('life_style_sulu_swoox_massive_search');

        $rootNode
            ->children()
                ->scalarNode('swoox_api_url')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('swoox_client_id')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('swoox_slot_locale')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('swoox_request_default_limit')->defaultValue(20)->end()
                ->scalarNode('swoox_filter_select_sorting')->info('Possible values are: SORT_REGULAR, SORT_NATURAL')->defaultValue('none')->end()
            ->end()
        ;

        $rootNode
            ->children()
                ->arrayNode('responsible')
                    ->prototype('scalar')
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
