<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Pagination\LsPaginationInterface;
use LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Mapper\SwooxItemInterface;
use Swoox\Api\Model\Response\Search\Standard\Item;

/**
 * Class SwooxPagination
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View\Model
 */
class SwooxPagination implements LsPaginationInterface
{
    /**
     * @var SwooxItemInterface[]|Item[]
     */
    private $items = [];

    /**
     * @var int
     */
    private $count = 0;

    /**
     * @param SwooxItemInterface|Item $item
     */
    public function addItem($item)
    {
        $this->items[] = $item;
    }

    /**
     * @return array
     */
    public function getSortableList()
    {
        return $this->items;
    }

    /**
     * @return integer
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     */
    public function setCount(int $count): void
    {
        $this->count = $count;
    }
}
