<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Sulu\SwooxMassiveSearchBundle\View;

use LifeStyle\Sulu\SwooxMassiveSearchBundle\Pagination\LsPaginationInterface;
use Knp\Component\Pager\Pagination\PaginationInterface;

/**
 * Interface SearchEngineInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Sulu\SwooxMassiveSearchBundle\View
 */
interface SearchEngineInterface
{
    /**
     * @param array $searchParams
     * @param string $locale
     * @return LsPaginationInterface
     */
    public function search(array $searchParams, string $locale): LsPaginationInterface;

    /**
     * @param array $searchParams
     * @param string $locale
     * @return PaginationInterface
     */
    public function paginatedSearch(array $searchParams, string $locale): PaginationInterface;
}
