# SwooxRestClientBundle
This Bundle provides a set of REST Services for client applications to connect the Swoox REST API.


## Installation

**1 . Make sure you've added the repository in your composer.json file:**
 
 ```json
     {
         "repositories": [
             {
                 "type": "vcs",
                 "url": "ssh://git@stash.life-style.de:7999/sb/swoox-rest-client.git"
             },
             {
                 "type": "vcs",
                 "url": "ssh://git@stash.life-style.de:7999/sx/swooxapimodel.git"
             }
         ]
     }
 ```

**2. Require the bundle with Composer:**
```bash
$ composer require lifestyle/swoox-rest-client-bundle dev-develop
```

**3. Register the bundle:**
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    $bundles = [
        new \Lifestyle\Swoox\RestApiClientBundle\LifestyleSwooxRestApiClientBundle(),
    ];
 
    // ...
}
```

**4. Now you can use the following REST Service provided by Symfony DI Component (service id):**
- lifestyle_swoox_rest_api_client.services.item.handler

### Configuration

Add the following parameters to your parameters.yml:

```yaml
lifestyle_swoox_rest_api_client.client_id: 1015
lifestyle_swoox_rest_api_client.index_url: "http://swoox-6-api.test.life-style.de/api/v1/index/swoox.json"
lifestyle_swoox_rest_api_client.delete_url: "http://swoox-6-api.test.life-style.de/api/v1/delete/swoox.json"
lifestyle_swoox_rest_api_client.request_format: "json"
```
