<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Swoox\RestApiClientBundle\DependencyInjection;

use Lifestyle\Swoox\RestApiClientBundle\Exception\InvalidConfigurationException;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * Class LifestyleSwooxRestApiClientExtension
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Swoox\RestApiClientBundle\DependencyInjection
 */
class LifestyleSwooxRestApiClientExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $this->configureServiceHandlerConfig($container);
    }

    /**
     * As this bundle is used in Pimcore plugins it is not possible to use the symfony tree builder
     * Use simple paramaters
     *
     * @param ContainerBuilder $container
     * @return array
     */
    private function receiveConfiguration(ContainerBuilder $container)
    {
        $bag = $container->getParameterBag();

        return [
            'client_id' => $this->getParameter($bag, 'lifestyle_swoox_rest_api_client.client_id', 0),
            'index_url' => $this->getParameter($bag, 'lifestyle_swoox_rest_api_client.index_url', ''),
            'delete_url' => $this->getParameter($bag, 'lifestyle_swoox_rest_api_client.delete_url', ''),
            'request_format' => $this->getParameter($bag, 'lifestyle_swoox_rest_api_client.request_format', 'json'),
            'responsible_classes' => $this->getParameter($bag, 'lifestyle_swoox_rest_api_client.responsible_classes', []),
        ];
    }

    /**
     * @param ParameterBagInterface $bag
     * @param string $name
     * @param mixed $default
     * @return mixed
     */
    private function getParameter(ParameterBagInterface $bag, $name, $default)
    {
        return $bag->has($name) ? $bag->get($name) : $default;
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidConfigurationException
     */
    private function configureServiceHandlerConfig(ContainerBuilder $container)
    {
        $serviceId = 'lifestyle_swoox_rest_api_client.services.item.config';
        if (!$container->hasDefinition($serviceId)) {
            throw new InvalidConfigurationException(
                sprintf(
                    'Unable to configure service-id "%s". Service does not exist!',
                    $serviceId
                )
            );
        }

        $config = $this->receiveConfiguration($container);

        $definition = $container->getDefinition($serviceId);
        $definition->setArguments([
            $config['client_id'],
            $config['index_url'],
            $config['delete_url'],
            $config['request_format'],
            $config['responsible_classes'],
            new Reference('validator'),
        ]);
    }
}
