<?php

/**
 * Class ConfigTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Swoox\RestApiClientBundle\Services\Item;

use Lifestyle\Swoox\RestApiClientBundle\Services\Item\Config;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class ConfigTest
 * @package Tests\Lifestyle\Swoox\RestApiClientBundle\Services\Item
 */
class ConfigTest extends TestCase
{

    public function testConfiguration()
    {
        $clientId = 12345;
        $indexUrl = 'unit_test_index_url';
        $deleteUrl = 'unit_test_delete_url';
        $requestFormat = 'unit_test_format';
        $responsibleClasses = [ 'classOne', 'classTwo' ];
        $validator = $this->getMockBuilder(ValidatorInterface::class)->getMock();

        $config = new Config(
            $clientId,
            $indexUrl,
            $deleteUrl,
            $requestFormat,
            $responsibleClasses,
            $validator
        );

        $this->assertEquals($clientId, $config->getClientId());
        $this->assertEquals($indexUrl, $config->getIndexUrl());
        $this->assertEquals($deleteUrl, $config->getDeleteUrl());
        $this->assertEquals($requestFormat, $config->getRequestFormat());
        $this->assertEquals($responsibleClasses, $config->getResponsibleClasses());
    }
}
