<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Swoox\RestApiClientBundle\DependencyInjection\Compiler;

use Lifestyle\Swoox\RestApiClientBundle\DependencyInjection\Compiler\AddFallbackLoggerPass;
use PHPUnit\Framework\TestCase;
use Psr\Log\NullLogger;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class AddFallbackLoggerPassTest
 * @package Tests\Lifestyle\Swoox\RestApiClientBundle\DependencyInjection\Compiler
 */
class AddFallbackLoggerPassTest extends TestCase
{
    public function testAddFallbackPsrNullLogger()
    {
        $container = new ContainerBuilder();

        // At first, logger service should not be registered.
        $this->assertFalse($container->has('logger'));

        $pass = new AddFallbackLoggerPass();
        $pass->process($container);

        $this->assertTrue($container->has('logger'));
        $this->assertInstanceOf(NullLogger::class, $container->get('logger'));
    }

    public function testNoFallbackLoggerWillBeAdded()
    {
        $container = new ContainerBuilder();
        $container->register('logger', \stdClass::class);

        // At first, logger service should exist.
        $this->assertTrue($container->has('logger'));

        $pass = new AddFallbackLoggerPass();
        $pass->process($container);

        $this->assertTrue($container->has('logger'));
        $this->assertInstanceOf(\stdClass::class, $container->get('logger'));
    }
}
