<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Swoox\RestApiClientBundle\Helper;

use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerInterface;
use Lifestyle\Swoox\RestApiClientBundle\Helper\Factory;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Tests\Lifestyle\Swoox\RestApiClientBundle\Helper
 */
class FactoryTest extends TestCase
{
    public function testGetSerializer()
    {
        $factory = new Factory();
        $this->assertInstanceOf(SerializerInterface::class, $factory->serializer());
    }

    public function testGetClient()
    {
        $factory = new Factory();
        $this->assertInstanceOf(ClientInterface::class, $factory->client());
    }
}
