<?php

/**
 * Class ConfigurationTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Swoox\RestApiClientBundle\DependencyInjection;

use Lifestyle\Swoox\RestApiClientBundle\DependencyInjection\Configuration;
use Matthias\SymfonyConfigTest\PhpUnit\ConfigurationTestCaseTrait;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigurationTest
 * @package Tests\Lifestyle\Swoox\RestApiClientBundle\DependencyInjection
 */
class ConfigurationTest extends TestCase
{
    use ConfigurationTestCaseTrait;

    protected function getConfiguration()
    {
        return new Configuration();
    }

    public function testProcessConfiguration()
    {
        $configuredOptions = [
            'request_format' => 'unit_test_json',
            'client_id' => 1234,
            'index_url' => 'unit_test_index_url',
            'delete_url' => 'unit_test_delete_url',
        ];

        $this->assertProcessedConfigurationEquals(
            [$configuredOptions],
            $configuredOptions);
    }

    public function testProcessConfigurationClientIdMustBeInteger()
    {
        $configuredOptions = [
            'request_format' => 'unit_test_json',
            'client_id' => '12345',
            'index_url' => 'unit_test_index_url',
            'delete_url' => 'unit_test_delete_url',
        ];

        $this->assertConfigurationIsInvalid(
            [$configuredOptions],
            'Invalid type for path "lifestyle_swoox_rest_api_client.client_id". Expected int, but got string.'
        );
    }
}
