# SwooxRestClientBundle
This Bundle provides a set of REST Services for client applications to connect the Swoox REST API.


## Installation

**1 . Make sure you've added the repository in your composer.json file:**
 
 ```json
     {
         "repositories": [
             {
                 "type": "vcs",
                 "url": "ssh://git@stash.life-style.de:7999/sb/swoox-rest-client.git"
             },
             {
                 "type": "vcs",
                 "url": "ssh://git@stash.life-style.de:7999/sx/swooxapimodel.git"
             }
         ]
     }
 ```

**2. Require the bundle with Composer:**
```bash
$ composer require lifestyle/swoox-rest-client-bundle dev-develop
```

**3. Register bundle:**

_Symfony 3:_
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    $bundles = [
        new \Lifestyle\Swoox\RestApiClientBundle\LifestyleSwooxRestApiClientBundle(),
    ];
 
    // ...
}
```

_Symfony 4:_
```php
// config/bundles.php
<?php

return [
    // ...
    Lifestyle\Swoox\RestApiClientBundle\LifestyleSwooxRestApiClientBundle::class => ['all' => true],
    // ...
];
```

**4. Now you can use the following REST Service provided by Symfony DI Component (service id):**
- lifestyle_swoox_rest_api_client.services.item.handler

### Configuration

Adjust the following and add parameters to your parameters.yml:
```yaml
parameters:
    lifestyle_swoox_rest_api_client.client_id: 1015
    lifestyle_swoox_rest_api_client.index_url: "http://swoox-6-api.test.life-style.de/api/v1/index/swoox.json"
    lifestyle_swoox_rest_api_client.delete_url: "http://swoox-6-api.test.life-style.de/api/v1/delete/swoox.json"
    lifestyle_swoox_rest_api_client.request_format: "json" # default: json
    lifestyle_swoox_rest_api_client.responsible_classes: [ 'Product', 'Variant' ] # optional
```

### Logging

This bundle uses the monolog logger and provides its own channel **swoox_rest_client**.
To log into a separate file read the Symfony documentation:
[How to Log Messages to different Files](https://symfony.com/doc/current/logging/channels_handlers.html)

Example:
```yaml
monolog:
    channels: [swoox_rest_client]
    handlers:
        swoox_rest_client:
            type: rotating_file
            path: "%kernel.logs_dir%/swoox_rest_client.log"
            level: debug
            buffer_size: 30
            channels: [swoox_rest_client]
```