# Life-Style Symfony Bundle To Handle Account Updates

This bundle receives messages from rabbitMQ and creates/updates customers and addresses in Sylius.

## Requirements

Sylius 1.3

## Installation
Add the repository to your `composer.json`
```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylesyliusaccountconsumerbundle.git"
    }
  ]
}
```
Install the package:
```bash
composer require lifestyle/sylius-account-consumer
```

## Configuration
Add the new config file `config/packages/lifestyle_sylius_account_consumer.yaml` to your main project packages configs
```yaml
imports:
- { resource: "@LifestyleSyliusAccountConsumer/Resources/config/config.yml" }

lifestyle_sylius_account_consumer:
  account:
    responsible_events:
      publish: [ 'account.publish' ]
      unpublish: [ 'account.unpublish' ]
  address:
    responsible_events:
      publish: [ 'address.publish' ]
      unpublish: [ 'address.unpublish' ]
  customergroup:
    responsible_events:
      publish: [ 'customergroup.publish' ]
      unpublish: [ 'customergroup.unpublish' ]
```

## DB-Migrations
Copy the migration files from `lifestyle-sylius-account-consumer/src/Migrations` to your projects `src/Migrations` folder.
